// MVStyleWindow.js Ver.1.1.0
// MIT License (C) 2021 あわやまたな
// http://opensource.org/licenses/mit-license.php

/*:
* @target MZ
* @plugindesc  You can bring it closer to the MV window.
* @author あわやまたな (Awaya_Matana)
* @url https://awaya3ji.seesaa.net/
* @help Ver.1.1.0
* The font size is 28 for MV and 26 for MZ.
*
* @param isHoverEnabled
* @text Enable Mouseover
* @desc Behavior when hovering the mouse cursor over a choice.
* False when reproducing the MV specification.
* @default false
* @type boolean
*
* @param drawBackgroundRect
* @text Draw Background Rect
* @desc Displays a rectangle behind the choice.
* False when reproducing the MV specification.
* @default false
* @type boolean
*
* @param outlineWidth
* @text Outline Width
* @desc 4 when reproducing the MV specification. MZ is 3.
* @default 4
* @type number
*
* @param itemTextAlign
* @text Item Text Align
* @desc Left when reproducing MV specifications, center for MZ.
* @default left
* @type select
* @option left
* @option center
* @option right
*/

/*:ja
* @target MZ
* @plugindesc  MVのウィンドウに近づけられます。
* @author あわやまたな (Awaya_Matana)
* @url https://awaya3ji.seesaa.net/
* @help フォントサイズはMVが28、MZが26です。
*
* [更新履歴]
* 2021/08/26：Ver.1.0.0　公開。
* 2022/12/12：Ver.1.1.0　アウトライン幅を0にした時の挙動を修正。
*
* @param isHoverEnabled
* @text マウスオーバー有効
* @desc マウスカーソルを選択肢にかざした時の挙動。
* MV仕様を再現する時はfalse。
* @default false
* @type boolean
*
* @param drawBackgroundRect
* @text 背景の矩形描画
* @desc 選択肢背後の四角を表示するか。
* MV仕様を再現する時はfalse。
* @default false
* @type boolean
*
* @param outlineWidth
* @text アウトライン幅
* @desc MV仕様を再現する時は4。MZは3。
* @default 4
* @type number
*
* @param itemTextAlign
* @text テキストの整列
* @desc MV仕様を再現する時は左、MZは中央。
* @default left
* @type select
* @option 左
* @value left
* @option 中央
* @value center
* @option 右
* @value right
*/
'use strict';
{
	//プラグイン名取得
	const pluginName = document.currentScript.src.replace(/^.*\/(.*).js$/, function() {
		return arguments[1];
	});
	//プラグインパラメーター取得
	const parameter = PluginManager.parameters(pluginName);
	const isHoverEnabled = parameter['isHoverEnabled'] === 'true';
	const drawBackgroundRect = parameter['drawBackgroundRect'] === 'false';
	const outlineWidth = Number(parameter['outlineWidth']) || 0;
	const itemTextAlign = parameter['itemTextAlign'] || 'left';
	
	Window_Selectable.prototype.isHoverEnabled = function() {
		return isHoverEnabled;
	};
	
	const _Window_Base_createContents = Window_Base.prototype.createContents;
	Window_Base.prototype.createContents = function() {
		_Window_Base_createContents.call(this);
		this.contents.outlineWidth = outlineWidth;
	};

	if (outlineWidth === 0) {
		const _Window_Base_resetTextColor = Window_Base.prototype.resetTextColor;
		Window_Base.prototype.resetTextColor = function() {
			_Window_Base_resetTextColor.call(this);
			this.changeOutlineColor("rgba(0, 0, 0, 0)");
		};
	}

	if (drawBackgroundRect) {
		const _Window_Selectable_drawBackgroundRect = Window_Selectable.prototype.drawBackgroundRect;
		Window_Selectable.prototype.drawBackgroundRect = function(rect) {
			rect.width = 0;
			rect.height = 0;
			_Window_Selectable_drawBackgroundRect.call(this, rect);
		};
	}
	
	Window_Command.prototype.itemTextAlign = function() {
		return itemTextAlign;
	};
	
}